<?php
// 这是一个用于处理首页排序请求的AJAX接口

// 设置JSON响应头
header('Content-Type: application/json');

// 检查是否已安装程序
$isInstalled = false;

// 1. 检查配置文件是否存在
if (file_exists('config.php')) {
    // 尝试包含配置文件
    try {
        require_once 'config.php';
        
        // 2. 尝试连接数据库
        $pdo = getDbConnection();
        
        // 3. 检查是否存在必要的表
        $stmt = $pdo->query("SHOW TABLES LIKE 'admin_users'");
        if ($stmt->rowCount() > 0) {
            $isInstalled = true;
        }
    } catch (Exception $e) {
        // 配置文件存在但无法连接数据库或缺少必要的表
        $isInstalled = false;
    }
}

// 如果未安装，返回错误
if (!$isInstalled) {
    echo json_encode(['success' => false, 'error' => '系统未安装']);
    exit;
}

// 获取排序方式参数，默认为按最新更新
$sortBy = isset($_GET['sort']) && $_GET['sort'] === 'hot' ? 'hot' : 'latest';

// 创建统一的状态过滤条件SQL片段
$statusFilterSql = "INNER JOIN video_types vt ON m.type = vt.id 
    INNER JOIN movie_categories mc ON m.category_id = mc.id 
    WHERE m.status = 1 
    AND vt.status = 1 
    AND mc.status = 1";

// 从数据库动态获取所有启用的视频类型
$videoTypes = [];
$typeCategories = [];
$typeMovies = [];

try {
    // 获取所有启用状态的视频类型
    $stmt = $pdo->prepare("SELECT * FROM video_types WHERE status = 1 ORDER BY sort_order ASC");
    $stmt->execute();
    $videoTypes = $stmt->fetchAll();
    
    // 为每种视频类型获取分类和视频数据
    foreach ($videoTypes as $type) {
        $typeId = $type['id'];
        
        // 获取该类型下的所有分类
        $stmt = $pdo->prepare("SELECT * FROM movie_categories WHERE type = :typeId AND status = 1");
        $stmt->bindParam(':typeId', $typeId, PDO::PARAM_INT);
        $stmt->execute();
        $typeCategories[$typeId] = $stmt->fetchAll();
        
        // 根据排序方式决定ORDER BY子句
        $orderByClause = $sortBy === 'hot' ? 'ORDER BY m.view_count DESC' : 'ORDER BY m.create_time DESC';
        
        // 获取该类型下的视频 - 根据选择的排序方式排序
        $stmt = $pdo->prepare("SELECT m.* FROM movies m 
            $statusFilterSql 
            AND m.type = :typeId 
            $orderByClause LIMIT 12");
        $stmt->bindParam(':typeId', $typeId, PDO::PARAM_INT);
        $stmt->execute();
        $typeMovies[$typeId] = $stmt->fetchAll();
    }
} catch (PDOException $e) {
    // 出错时返回错误信息
    echo json_encode(['success' => false, 'error' => '数据库查询错误']);
    exit;
}

// 生成HTML内容
ob_start();
$firstSection = true;
foreach ($videoTypes as $type) {
    $typeId = $type['id'];
    $typeMoviesList = $typeMovies[$typeId] ?? [];
    
    if (!empty($typeMoviesList)) {
        ?>
        <section class="movie-section<?php echo $firstSection ? '' : ' mt-10'; ?>">
            <?php $firstSection = false; ?>
            <div class="flex flex-wrap items-center justify-between gap-2 mb-4">
                <h3 class="text-2xl font-bold">
                    <?php echo $sortBy === 'hot' ? '热门' : '最新'; ?><?php echo htmlspecialchars($type['name']); ?>
                </h3>
                <div class="flex-1">
                    <ul class="flex flex-wrap gap-2 justify-end">
                        <?php if (isset($typeCategories[$typeId]) && !empty($typeCategories[$typeId])): ?>
                            <?php foreach ($typeCategories[$typeId] as $category): ?>
                                <li><a href="category.php?type=<?php echo $category['type']; ?>&category_id=<?php echo $category['id']; ?>" class="px-3 py-1 text-sm bg-secondary rounded-full text-primary hover:bg-primary hover:text-white transition-all">
                                    <?php echo htmlspecialchars($category['name']); ?>
                                </a></li>
                            <?php endforeach; ?>
                        <?php endif; ?>
                        <li><a href="category.php?type=<?php echo $typeId; ?>" class="px-3 py-1 text-sm bg-secondary rounded-full text-primary hover:bg-primary hover:text-white transition-all">全部</a></li>
                    </ul>
                </div>
            </div>
            <div class="movie-list grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-6 gap-4">
                <?php foreach ($typeMoviesList as $movie): ?>
                    <div class="movie-item relative h-64 rounded-lg overflow-hidden shadow hover:-translate-y-2 hover:shadow-lg transition-all duration-300 bg-dark-light">
                        <a href="play.php?id=<?php echo $movie['id']; ?>" class="block h-full">
                            <img src="<?php echo $movie['cover_img'] ?: 'images/default_cover.jpg'; ?>" alt="<?php echo $movie['title']; ?>" class="absolute inset-0 w-full h-full object-cover transition-transform duration-500 hover:scale-110">
                            <div class="absolute top-2 right-2 bg-black/70 text-white text-xs px-2 py-1 rounded-full">
                                热度: <?php echo $movie['view_count']; ?>
                            </div>
                            <div class="absolute bottom-0 left-0 right-0 bg-gradient-to-t from-black/90 to-transparent p-3 text-white">
                                <h4 class="text-base font-medium line-clamp-1 mb-1"><?php echo $movie['title']; ?></h4>
                                <p class="text-xs text-gray-300 line-clamp-1 mb-1 opacity-80"><?php echo $movie['director']; ?> | <?php echo $movie['actors']; ?></p>
                                <div class="flex justify-between items-center">
                                    <p class="text-xs text-gray-400 opacity-80 m-0"><?php echo $movie['release_year']; ?></p>
                                    <p class="text-xs text-gray-400 opacity-80 m-0">共<?php echo $movie['total_episodes']; ?>集</p>
                                </div>
                            </div>
                        </a>
                    </div>
                <?php endforeach; ?>
            </div>
        </section>
        <?php
    }
}
$content = ob_get_clean();

// 返回JSON响应
echo json_encode([
    'success' => true,
    'content' => $content,
    'sortBy' => $sortBy
]);
exit;