<?php
// 引入登录检查文件
require_once('includes/check_login.php');

// 引入数据库配置
require_once('../config.php');

// 初始化变量
$username = $_SESSION['admin_username'];
$password = '';
$confirm_password = '';
$error = '';
$success = '';

// 获取数据库连接
$pdo = getDbConnection();

// 处理表单提交
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // 获取表单数据
    $current_password = $_POST['current_password'];
    $new_password = $_POST['new_password'];
    $confirm_new_password = $_POST['confirm_new_password'];
    $new_username = $_POST['username'];
    
    // 验证数据
    if (empty($current_password)) {
        $error = "请输入当前密码";
    } else if (empty($new_username)) {
        $error = "用户名不能为空";
    } else if ($new_username != $username && strlen($new_username) < 3) {
        $error = "新用户名长度至少为3位";
    } else {
        // 验证当前密码是否正确
        $sql = "SELECT password FROM admin_users WHERE username = ?";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $username);
        $stmt->execute();
        
        if ($stmt->rowCount() > 0) {
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            $stored_password = $row['password'];
            
            // 验证当前密码
            if (!password_verify($current_password, $stored_password)) {
                $error = "当前密码不正确";
            } else {
                // 检查新用户名是否已存在
                if ($new_username != $username) {
                    $sql = "SELECT id FROM admin_users WHERE username = ?";
                    $stmt = $pdo->prepare($sql);
                    $stmt->bindParam(1, $new_username);
                    $stmt->execute();
                    
                    if ($stmt->rowCount() > 0) {
                        $error = "该用户名已被使用";
                    }
                }
                
                if (empty($error)) {
                    // 准备更新字段
                    $updateFields = [];
                    $params = [];
                    
                    // 如果用户名变更，则添加到更新字段
                    if ($new_username != $username) {
                        $updateFields[] = "username = ?";
                        $params[] = $new_username;
                    }
                    
                    // 如果提供了新密码，则添加到更新字段
                    if (!empty($new_password)) {
                        if ($new_password != $confirm_new_password) {
                            $error = "两次输入的新密码不一致";
                        } else if (strlen($new_password) < 6) {
                            $error = "新密码长度至少为6位";
                        } else {
                            $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
                            $updateFields[] = "password = ?";
                            $params[] = $hashed_password;
                        }
                    }
                    
                    if (empty($error)) {
                        if (!empty($updateFields)) {
                            // 添加WHERE条件参数
                            $params[] = $username;
                            
                            // 构建SQL语句
                            $sql = "UPDATE admin_users SET " . implode(", ", $updateFields) . " WHERE username = ?";
                            $stmt = $pdo->prepare($sql);
                            
                            if ($stmt->execute($params)) {
                                // 如果用户名变更，更新会话中的用户名
                                if ($new_username != $username) {
                                    $_SESSION['admin_username'] = $new_username;
                                    $username = $new_username;
                                }
                                
                                $success = "管理员信息修改成功";
                            } else {
                                $error = "修改失败：" . implode(", ", $stmt->errorInfo());
                            }
                        } else {
                            $success = "管理员信息未变更";
                        }
                    }
                }
            }
        } else {
            $error = "管理员不存在";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>修改管理员信息 - 后台管理</title>
    <link rel="stylesheet" href="css/style.css">
    <script src="js/main.js"></script>
</head>
<body>
    <?php include('includes/header.php'); ?>
    
    <div class="container">
        <div class="content-wrapper">
            <?php include('includes/sidebar.php'); ?>
            
            <div class="content">
                <div class="main-content">
                    <div class="breadcrumb">
                        <a href="index.php">首页</a> &gt; 
                        <span>修改管理员信息</span>
                    </div>
                    
                    <div class="panel">
                        <div class="panel-header">
                            <h2>修改管理员信息</h2>
                        </div>
                        
                        <div class="panel-body">
                            <!-- 显示错误消息 -->
                            <?php if (!empty($error)): ?>
                                <div class="alert alert-error">
                                    <?php echo $error; ?>
                                </div>
                            <?php endif; ?>
                            
                            <!-- 显示成功消息 -->
                            <?php if (!empty($success)): ?>
                                <div class="alert alert-success">
                                    <?php echo $success; ?>
                                </div>
                            <?php endif; ?>
                            
                            <!-- 修改管理员信息表单 -->
                            <form action="admin_edit.php" method="post">
                                <div class="form-group">
                                    <label for="username">用户名 <span class="required">*</span></label>
                                    <input type="text" id="username" name="username" value="<?php echo htmlspecialchars($username); ?>" required>
                                    <p class="form-hint">用户名长度至少为3位</p>
                                </div>
                                
                                <div class="form-group">
                                    <label for="current_password">当前密码 <span class="required">*</span></label>
                                    <input type="password" id="current_password" name="current_password" placeholder="请输入当前密码" required>
                                </div>
                                
                                <div class="form-group">
                                    <label for="new_password">新密码</label>
                                    <input type="password" id="new_password" name="new_password" placeholder="请输入新密码（留空则不修改）">
                                    <p class="form-hint">密码长度至少为6位</p>
                                </div>
                                
                                <div class="form-group">
                                    <label for="confirm_new_password">确认新密码</label>
                                    <input type="password" id="confirm_new_password" name="confirm_new_password" placeholder="请再次输入新密码">
                                </div>
                                
                                <div class="form-actions">
                                    <button type="submit" class="btn btn-primary">保存修改</button>
                                    <a href="index.php" class="btn btn-default">返回首页</a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <?php include('includes/footer.php'); ?>
</body>
</html>