<?php
// 轮播图管理页面
require_once 'includes/check_login.php';
require_once '../config.php';

// 获取数据库连接
$pdo = getDbConnection();

// 初始化消息变量
$success = '';
$error = '';

// 处理添加轮播图
if (isset($_POST['add_banner'])) {
    $movie_id = $_POST['movie_id'];
    $title = $_POST['title'];
    $description = $_POST['description'];
    $image_url = $_POST['image_url'];
    $sort_order = $_POST['sort_order'];
    $status = $_POST['status'];
    
    try {
        $sql = "INSERT INTO banner (movie_id, title, description, image_url, sort_order, status) VALUES (?, ?, ?, ?, ?, ?)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$movie_id, $title, $description, $image_url, $sort_order, $status]);
        $success = '轮播图添加成功';
        // 重置表单数据
        $editBanner = null;
    } catch (Exception $e) {
        $error = '轮播图添加失败: ' . $e->getMessage();
    }
}

// 处理编辑轮播图
if (isset($_POST['edit_banner'])) {
    $id = $_POST['id'];
    $movie_id = $_POST['movie_id'];
    $title = $_POST['title'];
    $description = $_POST['description'];
    $image_url = $_POST['image_url'];
    $sort_order = $_POST['sort_order'];
    $status = $_POST['status'];
    
    try {
        $sql = "UPDATE banner SET movie_id = ?, title = ?, description = ?, image_url = ?, sort_order = ?, status = ? WHERE id = ?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$movie_id, $title, $description, $image_url, $sort_order, $status, $id]);
        $success = '轮播图更新成功';
        // 重新获取编辑数据
        $sql = "SELECT * FROM banner WHERE id = ?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$id]);
        $editBanner = $stmt->fetch(PDO::FETCH_ASSOC);
    } catch (Exception $e) {
        $error = '轮播图更新失败: ' . $e->getMessage();
    }
}

// 处理删除轮播图
if (isset($_GET['action']) && $_GET['action'] == 'delete' && isset($_GET['id'])) {
    $id = $_GET['id'];
    try {
        $sql = "DELETE FROM banner WHERE id = ?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$id]);
        $success = '轮播图删除成功';
        // 如果正在编辑的是被删除的项，清空编辑数据
        if ($editBanner && $editBanner['id'] == $id) {
            $editBanner = null;
        }
    } catch (Exception $e) {
        $error = '轮播图删除失败: ' . $e->getMessage();
    }
    // 重新获取所有轮播图列表
    $banners = $pdo->query("SELECT b.*, m.title as movie_title FROM banner b LEFT JOIN movies m ON b.movie_id = m.id ORDER BY b.sort_order ASC")->fetchAll();
}

// 处理获取单个轮播图信息（用于编辑）
$editBanner = null;
if (isset($_GET['action']) && $_GET['action'] == 'edit' && isset($_GET['id'])) {
    $id = $_GET['id'];
    $sql = "SELECT * FROM banner WHERE id = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$id]);
    $editBanner = $stmt->fetch(PDO::FETCH_ASSOC);
}

// 获取所有轮播图
$banners = $pdo->query("SELECT b.*, m.title as movie_title FROM banner b LEFT JOIN movies m ON b.movie_id = m.id ORDER BY b.sort_order ASC")->fetchAll();

// 获取最新的视频列表（用于选择关联视频）
$latestMovies = $pdo->query("SELECT id, title, cover_img FROM movies WHERE status = 1 ORDER BY create_time DESC LIMIT 50")->fetchAll();
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>轮播图管理 - 爱影视</title>
    <link rel="stylesheet" href="css/style.css">
    <style>
        /* 轮播图管理样式 */
        .banner-form {
            background-color: #2d3748; /* 与main-content背景色一致 */
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 20px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.3);
            border: 1px solid #4a5568; /* 添加边框与整体风格一致 */
        }
        
        .banner-form h3 {
            color: #e0e0e0; /* 与页面标题颜色一致 */
            margin-bottom: 15px;
        }
        
        .banner-list {
            background-color: #2d3748; /* 与main-content背景色一致 */
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 2px 4px rgba(0,0,0,0.3);
            border: 1px solid #4a5568; /* 添加边框与整体风格一致 */
        }
        
        .banner-list h3 {
            color: #e0e0e0; /* 与页面标题颜色一致 */
            padding: 15px;
            border-bottom: 1px solid #4a5568;
        }
        
        .banner-item {
            display: flex;
            align-items: center;
            padding: 15px;
            border-bottom: 1px solid #4a5568;
        }
        
        .banner-item:last-child {
            border-bottom: none;
        }
        
        .banner-image {
            width: 100px;
            height: 60px;
            object-fit: cover;
            border-radius: 4px;
            margin-right: 15px;
        }
        
        .banner-info {
            flex: 1;
            color: #e0e0e0; /* 与整体文本颜色一致 */
        }
        
        .banner-info h4 {
            color: #e0e0e0; /* 与整体文本颜色一致 */
            margin-bottom: 5px;
        }
        
        .banner-info p {
            color: #cbd5e0; /* 与菜单文本颜色一致 */
            margin-bottom: 3px;
        }
        
        .banner-actions {
            display: flex;
            gap: 10px;
        }
        
        .form-row {
            display: flex;
            gap: 20px;
            margin-bottom: 15px;
        }
        
        .form-group {
            flex: 1;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 5px;
            font-weight: 500;
            color: #cbd5e0; /* 与菜单文本颜色一致 */
        }
        
        .form-group input,
        .form-group select,
        .form-group textarea {
            width: 100%;
            padding: 8px 12px;
            border: 1px solid #4a5568; /* 与边框颜色一致 */
            border-radius: 4px;
            background-color: #1a202c; /* 与侧边栏背景色一致 */
            color: #e0e0e0; /* 与文本颜色一致 */
        }
        
        .form-group input:focus,
        .form-group select:focus,
        .form-group textarea:focus {
            outline: none;
            border-color: #2c5282; /* 与链接悬停颜色一致 */
        }
        
        /* 使用CSS文件中已定义的按钮样式，不需要重复定义 */
        
        .status-active {
            color: #48bb78; /* 使用更适合深色主题的绿色 */
            font-weight: 500;
        }
        
        .status-inactive {
            color: #f56565; /* 使用更适合深色主题的红色 */
        }
        
        .no-data {
            padding: 30px;
            text-align: center;
            color: #a0aec0;
        }
    </style>
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container">
        <div class="content-wrapper">
            <?php include 'includes/sidebar.php'; ?>
            
            <div class="content">
                <div class="main-content">
                    <div class="page-header">
                        <h2>轮播图管理</h2>
                        <p>自定义首页轮播图</p>
                        <p>ps: 默认显示最新上架的影片海报</p>
                    </div>
                    
                    <!-- 轮播图表单 -->
                    <div class="banner-form">
                        <?php if ($error): ?>
                            <div class="alert alert-error"><?php echo $error; ?></div>
                        <?php endif; ?>
                        
                        <?php if ($success): ?>
                            <div class="alert alert-success"><?php echo $success; ?></div>
                        <?php endif; ?>
                        
                        <h3><?php echo $editBanner ? '编辑轮播图' : '添加轮播图'; ?></h3>
                        <form method="post" action="banner_manage.php">
                            <?php if ($editBanner): ?>
                                <input type="hidden" name="id" value="<?php echo $editBanner['id']; ?>">
                            <?php endif; ?>
                            
                            <div class="form-row">
                                <div class="form-group">
                                    <label for="movie_id">关联视频</label>
                                    <select id="movie_id" name="movie_id" required>
                                        <option value="">请选择视频</option>
                                        <?php foreach ($latestMovies as $movie): ?>
                                            <option value="<?php echo $movie['id']; ?>" <?php echo ($editBanner && $editBanner['movie_id'] == $movie['id']) ? 'selected' : ''; ?>>
                                                <?php echo $movie['title']; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                
                                <div class="form-group">
                                    <label for="sort_order">排序</label>
                                    <input type="number" id="sort_order" name="sort_order" min="0" value="<?php echo $editBanner ? $editBanner['sort_order'] : (count($banners) > 0 ? max(array_column($banners, 'sort_order')) + 1 : 0); ?>" required>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <label for="title">标题</label>
                                <input type="text" id="title" name="title" value="<?php echo $editBanner ? $editBanner['title'] : ''; ?>" required>
                            </div>
                            
                            <div class="form-group">
                                <label for="description">描述</label>
                                <textarea id="description" name="description"><?php echo $editBanner ? $editBanner['description'] : ''; ?></textarea>
                            </div>
                            
                            <div class="form-group">
                                <label for="image_url">图片URL</label>
                                <input type="text" id="image_url" name="image_url" value="<?php echo $editBanner ? $editBanner['image_url'] : ''; ?>" required>
                            </div>
                            
                            <div class="form-group">
                                <label for="status">状态</label>
                                <select id="status" name="status">
                                    <option value="1" <?php echo ($editBanner && $editBanner['status'] == 1) || !$editBanner ? 'selected' : ''; ?>>启用</option>
                                    <option value="0" <?php echo ($editBanner && $editBanner['status'] == 0) ? 'selected' : ''; ?>>禁用</option>
                                </select>
                            </div>
                            
                            <div class="form-actions">
                                <?php if ($editBanner): ?>
                                    <button type="submit" name="edit_banner" class="btn btn-primary">更新</button>
                                    <a href="banner_manage.php" class="btn btn-cancel">取消</a>
                                <?php else: ?>
                                    <button type="submit" name="add_banner" class="btn btn-primary">添加</button>
                                <?php endif; ?>
                            </div>
                        </form>
                    </div>
                    
                    <!-- 轮播图列表 -->
                    <div class="banner-list">
                        <h3>轮播图列表</h3>
                        <?php if (empty($banners)): ?>
                            <p class="no-data">暂无自定义轮播图数据</p>
                        <?php else: ?>
                            <?php foreach ($banners as $banner): ?>
                                <div class="banner-item">
                                    <img src="<?php echo $banner['image_url']; ?>" alt="<?php echo $banner['title']; ?>" class="banner-image">
                                    <div class="banner-info">
                                        <h4><?php echo $banner['title']; ?></h4>
                                        <p>关联视频: <?php echo $banner['movie_title']; ?></p>
                                        <p>排序: <?php echo $banner['sort_order']; ?> | 状态: <span class="<?php echo $banner['status'] == 1 ? 'status-active' : 'status-inactive'; ?>"><?php echo $banner['status'] == 1 ? '启用' : '禁用'; ?></span></p>
                                    </div>
                                    <div class="banner-actions">
                                        <a href="banner_manage.php?action=edit&id=<?php echo $banner['id']; ?>" class="btn btn-edit">编辑</a>
                                        <button type="button" class="btn btn-delete" onclick="confirmDeleteBanner(<?php echo $banner['id']; ?>, '<?php echo addslashes($banner['title']); ?>')">删除</button>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script>
    // 确认删除轮播图
    function confirmDeleteBanner(id, title) {
        if (confirm('确定要删除轮播图"' + title + '"吗？')) {
            window.location.href = 'banner_manage.php?action=delete&id=' + id;
        }
    }
    </script>
    
    <?php include 'includes/footer.php'; ?>
</body>
</html>