<?php
// 分类编辑/添加页面
require_once 'includes/check_login.php';
require_once '../config.php';

// 获取数据库连接
$pdo = getDbConnection();

$id = 0;
$name = '';
$type = 1;
$status = 1;
$error = '';
$success = '';

// 检查是否有ID参数
if (isset($_GET['id']) && is_numeric($_GET['id'])) {
    $id = intval($_GET['id']);
    
    // 获取分类信息
    $stmt = $pdo->prepare("SELECT * FROM movie_categories WHERE id = :id");
    $stmt->execute(['id' => $id]);
    $category = $stmt->fetch();
    
    if ($category) {
        $name = $category['name'];
        $type = $category['type'];
        $status = $category['status'];
    } else {
        header('Location: category_list.php');
        exit;
    }
}

// 获取视频类型列表
$videoTypes = array();
$sqlTypes = "SELECT id, name FROM video_types WHERE status = 1 ORDER BY sort_order ASC";
$stmtTypes = $pdo->prepare($sqlTypes);
$stmtTypes->execute();
while ($row = $stmtTypes->fetch(PDO::FETCH_ASSOC)) {
    $videoTypes[$row['id']] = $row['name'] . '分类';
}

// 处理表单提交
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // 获取表单数据
    $name = trim($_POST['name']);
    $type = intval($_POST['type']);
    $status = intval($_POST['status']);
    
    // 验证表单数据
    if (empty($name)) {
        $error = '分类名称不能为空';
    } else {
        // 检查分类名称是否已存在
        if ($id) {
            // 编辑模式，排除当前分类
            $stmt = $pdo->prepare("SELECT COUNT(*) FROM movie_categories WHERE name = :name AND type = :type AND id != :id");
            $stmt->execute(['name' => $name, 'type' => $type, 'id' => $id]);
        } else {
            // 添加模式
            $stmt = $pdo->prepare("SELECT COUNT(*) FROM movie_categories WHERE name = :name AND type = :type");
            $stmt->execute(['name' => $name, 'type' => $type]);
        }
        
        if ($stmt->fetchColumn() > 0) {
            $error = '该类型下已存在同名分类';
        } else {
            if ($id) {
                // 更新分类
                $stmt = $pdo->prepare("UPDATE movie_categories SET name = :name, type = :type, status = :status WHERE id = :id");
                if ($stmt->execute(['name' => $name, 'type' => $type, 'status' => $status, 'id' => $id])) {
                    $success = '分类更新成功';
                } else {
                    $error = '分类更新失败，请重试';
                }
            } else {
                // 添加新分类
                $stmt = $pdo->prepare("INSERT INTO movie_categories (name, type, status) VALUES (:name, :type, :status)");
                if ($stmt->execute(['name' => $name, 'type' => $type, 'status' => $status])) {
                    $success = '分类添加成功';
                    // 重置表单
                    $id = 0;
                    $name = '';
                    $type = 1;
                    $status = 1;
                } else {
                    $error = '分类添加失败，请重试';
                }
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $id ? '编辑分类' : '添加分类'; ?> - 爱影视</title>
    <link rel="stylesheet" href="css/style.css">
    <script src="js/main.js"></script>
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container">
        <div class="content-wrapper">
            <?php include 'includes/sidebar.php'; ?>
            
            <div class="content">
                <div class="main-content">
                    <div class="breadcrumb">
                        <a href="index.php">首页</a> &gt; 
                        <a href="category_list.php">分类管理</a> &gt; 
                        <span><?php echo $id ? '编辑分类' : '添加分类'; ?></span>
                    </div>
                    
                    <div class="panel">
                        <div class="panel-header">
                            <h3><?php echo $id ? '编辑分类' : '添加分类'; ?></h3>
                        </div>
                        
                        <div class="panel-body">
                            <?php if ($error): ?>
                                <div class="alert alert-error"><?php echo $error; ?></div>
                            <?php endif; ?>
                            
                            <?php if ($success): ?>
                                <div class="alert alert-success"><?php echo $success; ?></div>
                            <?php endif; ?>
                            
                            <form method="post">
                                <div class="form-group">
                                    <label for="name">分类名称 <span class="required">*</span></label>
                                    <input type="text" id="name" name="name" value="<?php echo htmlspecialchars($name); ?>" required>
                                </div>
                                
                                <div class="form-group">
                                    <label for="type">分类类型 <span class="required">*</span></label>
                                    <select id="type" name="type" required>
                                        <?php foreach ($videoTypes as $typeId => $typeName): ?>
                                            <option value="<?php echo $typeId; ?>" <?php echo ($type == $typeId) ? 'selected' : ''; ?>><?php echo $typeName; ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                
                                <div class="form-group">
                                    <label for="status">状态</label>
                                    <select id="status" name="status">
                                        <option value="1" <?php echo ($status == 1) ? 'selected' : ''; ?>>启用</option>
                                        <option value="0" <?php echo ($status == 0) ? 'selected' : ''; ?>>禁用</option>
                                    </select>
                                </div>
                                
                                <div class="form-actions">
                                    <button type="submit" class="btn-primary"><?php echo $id ? '更新分类' : '添加分类'; ?></button>
                                    <a href="category_list.php" class="btn-default">返回列表</a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <?php include 'includes/footer.php'; ?>
</body>
</html>