<?php
// 引入登录检查文件
require_once('includes/check_login.php');

// 引入数据库配置
require_once('../config.php');

// 初始化变量
$comment_id = '';
$content = '';
$status = '';
$video_title = '';
$username = '';
$ip_address = '';
$create_time = '';
$error = '';
$success = '';

// 获取数据库连接
$pdo = getDbConnection();

// 检查是否有comment_id参数
if (isset($_GET['id'])) {
    $comment_id = intval($_GET['id']);
    
    // 从数据库获取留言信息
    $sql = "SELECT c.*, m.title AS video_title FROM comments c LEFT JOIN movies m ON c.movie_id = m.id WHERE c.id = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(1, $comment_id);
    $stmt->execute();
    
    if ($stmt->rowCount() > 0) {
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        $content = $row['content'];
        $status = $row['status'];
        $video_title = $row['video_title'];
        $username = $row['username'];
        $ip_address = $row['ip_address'];
        $create_time = $row['create_time'];
    } else {
        $error = "留言不存在";
    }
} else {
    $error = "参数错误";
}

// 处理表单提交
if ($_SERVER['REQUEST_METHOD'] == 'POST' && !empty($comment_id)) {
    // 获取表单数据
    $new_content = $_POST['content'];
    $new_status = $_POST['status'];
    
    // 验证数据
    if (empty($new_content)) {
        $error = "留言内容不能为空";
    } else {
        // 更新留言内容和状态
        $sql = "UPDATE comments SET content = ?, status = ? WHERE id = ?";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(1, $new_content);
        $stmt->bindParam(2, $new_status);
        $stmt->bindParam(3, $comment_id);
        
        if ($stmt->execute()) {
            $success = "留言更新成功";
            $content = $new_content;
            $status = $new_status;
        } else {
            $error = "更新失败：" . implode(", ", $stmt->errorInfo());
        }
    }
}

// PDO连接不需要显式关闭
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>编辑留言 - 后台管理</title>
    <link rel="stylesheet" href="css/style.css">
    <script src="js/main.js"></script>
</head>
<body>
    <?php include('includes/header.php'); ?>
    
    <div class="container">
        <div class="content-wrapper">
            <?php include('includes/sidebar.php'); ?>
            
            <div class="content">
                <div class="main-content">
                    <div class="breadcrumb">
                        <a href="index.php">首页</a> &gt; 
                        <a href="comment_list.php">留言管理</a> &gt; 
                        <span>编辑留言</span>
                    </div>
                    
                    <!-- 保留原有的内容区域，不修改content中的子容器样式 -->
                    <div class="panel">
                        <div class="panel-header">
                            <h2>编辑留言</h2>
                        </div>
                        
                        <div class="panel-body">
                            <!-- 显示错误消息 -->
                            <?php if (!empty($error)): ?>
                                <div class="alert alert-error">
                                    <?php echo $error; ?>
                                </div>
                            <?php endif; ?>
                            
                            <!-- 显示成功消息 -->
                            <?php if (!empty($success)): ?>
                                <div class="alert alert-success">
                                    <?php echo $success; ?>
                                </div>
                            <?php endif; ?>
                            
                            <!-- 如果留言不存在，则不显示表单 -->
                            <?php if (empty($error)): ?>
                                <form action="comment_edit.php?id=<?php echo $comment_id; ?>" method="post">
                                    <div class="form-group">
                                        <label for="video_title">关联视频</label>
                                        <input type="text" id="video_title" value="<?php echo htmlspecialchars($video_title); ?>" disabled>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for="username">用户</label>
                                        <input type="text" id="username" value="<?php echo htmlspecialchars($username); ?>" disabled>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for="ip_address">IP地址</label>
                                        <input type="text" id="ip_address" value="<?php echo htmlspecialchars($ip_address); ?>" disabled>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for="create_time">创建时间</label>
                                        <input type="text" id="create_time" value="<?php echo htmlspecialchars($create_time); ?>" disabled>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for="content">留言内容 <span class="required">*</span></label>
                                        <textarea id="content" name="content" rows="6" placeholder="请输入留言内容"><?php echo htmlspecialchars($content); ?></textarea>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for="status">状态</label>
                                        <select id="status" name="status">
                                            <option value="1" <?php echo $status == 1 ? 'selected' : ''; ?>>已审核</option>
                                            <option value="0" <?php echo $status == 0 ? 'selected' : ''; ?>>待审核</option>
                                        </select>
                                    </div>
                                    
                                    <div class="form-actions">
                                        <button type="submit" class="btn btn-primary">保存更改</button>
                                        <a href="comment_list.php" class="btn btn-default">返回列表</a>
                                    </div>
                                </form>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <?php include('includes/footer.php'); ?>
</body>
</html>