<?php
// 后台侧边栏文件
$currentPage = basename($_SERVER['PHP_SELF']);
?>
<aside class="sidebar">
    <ul class="menu">
        <li class="menu-item <?php echo $currentPage == 'index.php' ? 'active' : ''; ?>">
            <a href="index.php">
                <span class="menu-icon">🏠</span>
                <span class="menu-text">首页</span>
            </a>
        </li>
        <!-- 将视频管理改为带子菜单的结构，并整合视频采集功能 -->
        <li class="menu-item has-submenu <?php echo strpos($currentPage, 'movie') !== false || $currentPage == 'video_collect.php' || $currentPage == 'search_collect.php' || $currentPage == 'bilibili_collect.php' || $currentPage == 'get_up_videos.php' ? 'active' : ''; ?>">
            <a href="#" class="menu-toggle">
                <span class="menu-icon">🎬</span>
                <span class="menu-text">视频管理</span>
                <span class="menu-arrow">▶</span>
            </a>
            <ul class="submenu">
                <li class="submenu-item <?php echo strpos($currentPage, 'movie') !== false ? 'active' : ''; ?>">
                    <a href="movie_list.php">
                        <span class="menu-icon">📋</span>
                        <span class="menu-text">视频列表</span>
                    </a>
                </li>
                <li class="submenu-item <?php echo $currentPage == 'video_collect.php' ? 'active' : ''; ?>">
                    <a href="video_collect.php">
                        <span class="menu-icon">📹</span>
                        <span class="menu-text">一键采集</span>
                    </a>
                </li>
                <li class="submenu-item <?php echo $currentPage == 'search_collect.php' ? 'active' : ''; ?>">
                    <a href="search_collect.php">
                        <span class="menu-icon">🔎</span>
                        <span class="menu-text">搜索采集</span>
                    </a>
                </li>
                <li class="submenu-item <?php echo $currentPage == 'bilibili_collect.php' ? 'active' : ''; ?>">
                    <a href="bilibili_collect.php">
                        <span class="menu-icon">📱</span>
                        <span class="menu-text">B站视频采集</span>
                    </a>
                </li>
                <!-- 添加B站按UP主采集入口 -->
                <li class="submenu-item <?php echo $currentPage == 'get_up_videos.php' ? 'active' : ''; ?>">
                    <a href="get_up_videos.php">
                        <span class="menu-icon">👤</span>
                        <span class="menu-text">B站按UP主采集</span>
                    </a>
                </li>
            </ul>
        </li>
        <!-- 创建新的类型和分类管理父菜单 -->
        <li class="menu-item has-submenu <?php echo strpos($currentPage, 'video_type') !== false || strpos($currentPage, 'category') !== false ? 'active' : ''; ?>">
            <a href="#" class="menu-toggle">
                <span class="menu-icon">📊</span>
                <span class="menu-text">类型和分类管理</span>
                <span class="menu-arrow">▶</span>
            </a>
            <ul class="submenu">
                <li class="submenu-item <?php echo strpos($currentPage, 'video_type') !== false ? 'active' : ''; ?>">
                    <a href="video_type_list.php">
                        <span class="menu-icon">🎬</span>
                        <span class="menu-text">视频类型管理</span>
                    </a>
                </li>
                <li class="submenu-item <?php echo strpos($currentPage, 'category') !== false ? 'active' : ''; ?>">
                    <a href="category_list.php">
                        <span class="menu-icon">📋</span>
                        <span class="menu-text">分类管理</span>
                    </a>
                </li>
            </ul>
        </li>
        
        <li class="menu-item <?php echo strpos($currentPage, 'comment') !== false ? 'active' : ''; ?>">
            <a href="comment_list.php">
                <span class="menu-icon">💬</span>
                <span class="menu-text">留言管理</span>
            </a>
        </li>
        <li class="menu-item <?php echo strpos($currentPage, 'banner') !== false ? 'active' : ''; ?>">
            <a href="banner_manage.php">
                <span class="menu-icon">🖼️</span>
                <span class="menu-text">轮播图管理</span>
            </a>
        </li>
    </ul>
</aside>

<style>
    /* 子菜单基础样式 */
    .submenu {
        display: none; /* 默认隐藏 */
        list-style: none;
        margin: 0;
        padding: 0;
        background-color: #1a202c !important; /* 与侧边栏背景色统一 */
    }
    
    .menu-item.has-submenu.open .submenu {
        display: block;
    }
    
    .submenu-item a {
        display: flex;
        align-items: center;
        padding: 15px 20px 15px 35px;
        color: #cbd5e0 !important; /* 确保文本颜色不受其他样式影响 */
        text-decoration: none;
        transition: all 0.3s;
        background-color: transparent !important; /* 默认透明背景 */
    }
    
    /* 增强选择器具体性并添加!important确保样式优先级 */
    .menu .menu-item.has-submenu .submenu .submenu-item a:hover {
        background-color: #2c5282 !important;
        color: #fff !important;
    }
    
    /* 只对active的子菜单项应用高亮背景 */
    .menu .menu-item.has-submenu .submenu .submenu-item.active a {
        background-color: #2c5282 !important;
        color: #fff !important;
    }
    
    /* 非active子菜单项保持默认样式 */
    .menu .menu-item.has-submenu .submenu .submenu-item:not(.active) a {
        background-color: transparent !important;
        color: #cbd5e0 !important;
    }
    
    /* 箭头动画 */
    .menu-arrow {
        transition: transform 0.3s ease;
        margin-left: auto;
        display: inline-block;
        font-size: 12px;
    }
    
    .menu-item.has-submenu.open .menu-arrow {
        transform: rotate(90deg);
    }
    
    /* 父级菜单项常驻活动状态样式 */
    .menu .menu-item.has-submenu.active > .menu-toggle {
        background-color: #2c5282 !important;
        color: #fff !important;
    }
</style>

<!-- 子菜单交互JavaScript -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // 为所有带有子菜单的菜单项添加点击事件
        const menuItems = document.querySelectorAll('.menu-item.has-submenu');
        menuItems.forEach(item => {
            const toggle = item.querySelector('.menu-toggle');
            
            toggle.addEventListener('click', function(e) {
                e.preventDefault();
                // 切换当前菜单项的open状态
                item.classList.toggle('open');
            });
            
            // 自动为当前页面所在的父级菜单添加open状态
            if (item.classList.contains('active')) {
                item.classList.add('open');
            }
        });
    });
</script>