<?php
// 后台首页
require_once 'includes/check_login.php';
require_once '../config.php';

// 获取数据库连接
$pdo = getDbConnection();

// 获取统计数据
$totalMovies = $pdo->query("SELECT COUNT(*) FROM movies WHERE status = 1")->fetchColumn();
// 修改为使用create_time字段获取今日更新的影片数量
$todayUpdatedMovies = $pdo->query("SELECT COUNT(*) FROM movies WHERE DATE(create_time) = CURDATE() AND status = 1")->fetchColumn();
$totalComments = $pdo->query("SELECT COUNT(*) FROM comments WHERE status = 1")->fetchColumn();
$todayComments = $pdo->query("SELECT COUNT(*) FROM comments WHERE DATE(create_time) = CURDATE() AND status = 1")->fetchColumn();
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>后台管理 - 爱影视</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container">
        <div class="content-wrapper">
            <?php include 'includes/sidebar.php'; ?>
            
            <div class="content">
                <div class="main-content">
                    <h2>欢迎回来，<?php echo $_SESSION['admin_username']; ?></h2>
                    
                    <div class="stats-container">
                        <div class="stat-item">
                            <div class="stat-value"><?php echo $totalMovies; ?></div>
                            <div class="stat-label">全部影片</div>
                        </div>
                        <div class="stat-item">
                            <div class="stat-value"><?php echo $todayUpdatedMovies; ?></div>
                            <div class="stat-label">今日更新</div>
                        </div>
                        <div class="stat-item">
                            <div class="stat-value"><?php echo $totalComments; ?></div>
                            <div class="stat-label">评论总数</div>
                        </div>
                        <div class="stat-item">
                            <div class="stat-value"><?php echo $todayComments; ?></div>
                            <div class="stat-label">今日评论</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <?php include 'includes/footer.php'; ?>
</body>
</html>