// 后台管理系统主JavaScript文件

// 页面加载完成后执行
document.addEventListener('DOMContentLoaded', function() {
    // 自动隐藏提示消息
    setTimeout(function() {
        const successMessages = document.querySelectorAll('.alert.alert-success');
        successMessages.forEach(function(message) {
            if (!message.classList.contains('fadeOut')) {
                message.style.animation = 'fadeOut 0.3s ease-in forwards';
                setTimeout(function() {
                    message.style.display = 'none';
                }, 300);
            }
        });
        
        const errorMessages = document.querySelectorAll('.alert.alert-error');
        errorMessages.forEach(function(message) {
            if (!message.classList.contains('fadeOut')) {
                message.style.animation = 'fadeOut 0.3s ease-in forwards';
                setTimeout(function() {
                    message.style.display = 'none';
                }, 300);
            }
        });
    }, 3000);
    
    
    // 示例：表单验证
    const forms = document.querySelectorAll('form');
    forms.forEach(form => {
        form.addEventListener('submit', function(e) {
            let isValid = true;
            const requiredFields = form.querySelectorAll('[required]');
            
            requiredFields.forEach(field => {
                if (!field.value.trim()) {
                    isValid = false;
                    field.style.borderColor = '#d9534f';
                } else {
                    field.style.borderColor = '#ddd';
                }
            });
            
            if (!isValid) {
                e.preventDefault();
                // 使用新的提示样式显示错误信息
                showErrorMessage('请填写所有必填字段！');
            }
        });
    });
    
    // 显示错误消息的函数
    function showErrorMessage(message) {
        // 先移除已有的错误消息
        const existingErrors = document.querySelectorAll('.alert.alert-error');
        existingErrors.forEach(err => err.remove());
        
        // 创建新的错误消息元素
        const errorDiv = document.createElement('div');
        errorDiv.className = 'alert alert-error';
        errorDiv.textContent = message;
        
        // 添加到页面
        const mainContent = document.querySelector('.main-content');
        if (mainContent) {
            mainContent.insertBefore(errorDiv, mainContent.firstChild);
        }
        
        // 3秒后自动隐藏
        setTimeout(function() {
            errorDiv.style.animation = 'fadeOut 0.3s ease-in forwards';
            setTimeout(function() {
                errorDiv.remove();
            }, 300);
        }, 3000);
    }
});