<?php
// 后台登录页面
require_once '../config.php';

// 检查是否已登录
session_start();
if (isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true) {
    header('Location: index.php');
    exit;
}

$error = '';

// 处理登录请求
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = trim($_POST['username']);
    $password = trim($_POST['password']);
    
    if (empty($username) || empty($password)) {
        $error = '请输入用户名和密码';
    } else {
        // 获取数据库连接
        $pdo = getDbConnection();
        
        // 查询管理员信息
        $stmt = $pdo->prepare("SELECT * FROM admin_users WHERE username = :username AND status = 1");
        $stmt->execute([':username' => $username]);
        $admin = $stmt->fetch();
        
        if ($admin && password_verify($password, $admin['password'])) {
            // 登录成功，设置会话
            $_SESSION['admin_logged_in'] = true;
            $_SESSION['admin_id'] = $admin['id'];
            $_SESSION['admin_username'] = $admin['username'];
            
            // 更新最后登录信息
            $ipAddress = $_SERVER['REMOTE_ADDR'];
            $stmt = $pdo->prepare("UPDATE admin_users SET last_login_time = NOW(), last_login_ip = :ip WHERE id = :id");
            $stmt->execute([':ip' => $ipAddress, ':id' => $admin['id']]);
            
            // 跳转到后台首页
            header('Location: index.php');
            exit;
        } else {
            $error = '用户名或密码错误';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>后台登录 - 爱影视</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
    <div class="login-container">
        <h1 class="login-title">爱影视 - 后台管理系统</h1>
        
        <?php if ($error): ?>
            <div class="error-message"><?php echo $error; ?></div>
        <?php endif; ?>
        
        <form method="post">
            <div class="form-group">
                <label for="username">用户名</label>
                <input type="text" id="username" name="username" placeholder="请输入用户名" required>
            </div>
            
            <div class="form-group">
                <label for="password">密码</label>
                <input type="password" id="password" name="password" placeholder="请输入密码" required>
            </div>
            
            <div class="form-group">
                <button type="submit">登录</button>
            </div>
        </form>
        
        </p>
    </div>
</body>
</html>