<?php
// 视频类型编辑页面
require_once 'includes/check_login.php';
require_once '../config.php';

// 获取数据库连接
$pdo = getDbConnection();

$id = 0;
$name = '';
$code = '';
$status = 1;
$sort_order = 0;
$error = '';
$success = '';

// 检查是否有ID参数
if (isset($_GET['id']) && is_numeric($_GET['id'])) {
    $id = intval($_GET['id']);
    
    // 获取视频类型信息
    $stmt = $pdo->prepare("SELECT * FROM video_types WHERE id = :id");
    $stmt->execute(['id' => $id]);
    $type = $stmt->fetch();
    
    if ($type) {
        $name = $type['name'];
        $code = $type['code'];
        $status = $type['status'];
        $sort_order = $type['sort_order'];
    } else {
        header('Location: video_type_list.php');
        exit;
    }
}

// 处理表单提交
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name']);
    $code = trim($_POST['code']);
    $status = intval($_POST['status']);
    $sort_order = intval($_POST['sort_order']);
    
    // 验证表单数据
    if (empty($name)) {
        $error = '类型名称不能为空';
    } elseif (empty($code)) {
        $error = '类型代码不能为空';
    } elseif (!preg_match('/^[a-zA-Z]+$/', $code)) {
        $error = '类型代码只能包含字母';
    } else {
        // 检查类型代码是否已存在
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM video_types WHERE code = :code" . ($id ? " AND id != :id" : ""));
        $params = ['code' => $code];
        if ($id) {
            $params['id'] = $id;
        }
        $stmt->execute($params);
        
        if ($stmt->fetchColumn() > 0) {
            $error = '该类型代码已存在';
        } else {
            if ($id) {
                // 更新视频类型
                $stmt = $pdo->prepare("UPDATE video_types SET name = :name, code = :code, status = :status, sort_order = :sort_order WHERE id = :id");
                $stmt->execute(['name' => $name, 'code' => $code, 'status' => $status, 'sort_order' => $sort_order, 'id' => $id]);
                $success = '视频类型更新成功';
            } else {
                // 添加视频类型
                $stmt = $pdo->prepare("INSERT INTO video_types (name, code, status, sort_order) VALUES (:name, :code, :status, :sort_order)");
                $stmt->execute(['name' => $name, 'code' => $code, 'status' => $status, 'sort_order' => $sort_order]);
                $success = '视频类型添加成功';
                
                // 重置表单
                $id = 0;
                $name = '';
                $code = '';
                $status = 1;
                $sort_order = 0;
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $id ? '编辑视频类型' : '添加视频类型'; ?> - 爱影视</title>
    <link rel="stylesheet" href="css/style.css">
    <script src="js/main.js"></script>
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container">
        <div class="content-wrapper">
            <?php include 'includes/sidebar.php'; ?>
            
            <div class="content">
                <div class="main-content">
                    <div class="breadcrumb">
                        <a href="index.php">首页</a> &gt; 
                        <a href="video_type_list.php">视频类型管理</a> &gt; 
                        <span><?php echo $id ? '编辑视频类型' : '添加视频类型'; ?></span>
                    </div>
                    
                    <div class="page-header">
                        <h2><?php echo $id ? '编辑视频类型' : '添加视频类型'; ?></h2>
                    </div>
                    
                    <?php if ($error): ?>
                        <div class="alert alert-error"><?php echo $error; ?></div>
                    <?php endif; ?>
                    
                    <?php if ($success): ?>
                        <div class="alert alert-success"><?php echo $success; ?></div>
                    <?php endif; ?>
                    
                    <div class="panel">
                        <div class="panel-body">
                            <form method="post">
                                <div class="form-group">
                                    <label for="name">类型名称 <span class="required">*</span></label>
                                    <input type="text" id="name" name="name" value="<?php echo htmlspecialchars($name); ?>" required>
                                </div>
                                
                                <div class="form-group">
                                    <label for="code">类型代码 <span class="required">*</span></label>
                                    <input type="text" id="code" name="code" value="<?php echo htmlspecialchars($code); ?>" required>
                                    <small>只能包含字母，用于系统内部识别</small>
                                </div>
                                
                                <div class="form-group">
                                    <label for="sort_order">排序</label>
                                    <input type="number" id="sort_order" name="sort_order" value="<?php echo $sort_order; ?>" min="0">
                                </div>
                                
                                <div class="form-group">
                                    <label for="status">状态</label>
                                    <select id="status" name="status">
                                        <option value="1" <?php echo $status == 1 ? 'selected' : ''; ?>>启用</option>
                                        <option value="0" <?php echo $status == 0 ? 'selected' : ''; ?>>禁用</option>
                                    </select>
                                </div>
                                
                                <div class="form-actions">
                                    <button type="submit" class="btn-primary">保存</button>
                                    <a href="video_type_list.php" class="btn-default">返回列表</a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <?php include 'includes/footer.php'; ?>
</body>
</html>