<?php
/**
 * 参数说明：
 * - url：B站视频链接
 * - p：视频选集（可选，默认为1）
 */
header('Referrer-Policy: no-referrer');

// 获取请求参数
$videoUrl = $_GET['url'] ?? '';
$requestedPage = (int)($_GET['p'] ?? 1);

// 解析BVID
$parsedUrl = parse_url($videoUrl);
$bvid = str_replace("/video/", "", $parsedUrl['path']);

// 设置请求头
$headers = ['Content-type: application/json;charset=UTF-8'];
$userAgent = 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/94.0.4606.81 Safari/537.36';

// 发送HTTP请求的辅助函数
function curlRequest($url, $headers, $userAgent) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_USERAGENT, $userAgent);
    $output = curl_exec($ch);
    curl_close($ch);
    return $output;
}

// 获取选集信息
$pagelistResponse = curlRequest("https://api.bilibili.com/x/player/pagelist?bvid={$bvid}", $headers, $userAgent);
$pagesData = json_decode($pagelistResponse, true);
$pages = $pagesData['data'];
$targetPage = $pages[$requestedPage - 1];
$cid = $targetPage['cid'];

// 获取播放信息并重定向
$playurlResponse = curlRequest("https://api.bilibili.com/x/player/playurl?otype=json&fnver=0&fnval=3&player=3&qn=64&bvid={$bvid}&cid={$cid}&platform=html5&high_quality=1", $headers, $userAgent);
$playInfo = json_decode($playurlResponse, true);

if (isset($playInfo['data']['durl'][0]['url'])) {
    $videoUrl = $playInfo['data']['durl'][0]['url'];
    // 判断是否需要替换域名
    if (strpos($videoUrl, 'upos-hz-mirrorakam.akamaized.net') !== false) {
        $videoUrl = str_replace('upos-hz-mirrorakam.akamaized.net', 'upos-sz-estgoss.bilivideo.com', $videoUrl);
    }
    header("Location: {$videoUrl}");
    exit;
}
?>
