<?php
// 引入数据库配置文件
require_once 'config.php';

// 设置返回JSON格式
header('Content-Type: application/json');

// 初始化响应数据
$response = [
    'success' => false,
    'message' => '',
    'comments' => []
];

// 检查请求方法和参数
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['movie_id']) && isset($_POST['username']) && isset($_POST['content'])) {
    $movieId = intval($_POST['movie_id']);
    $username = trim($_POST['username']);
    $content = trim($_POST['content']);
    $ipAddress = $_SERVER['REMOTE_ADDR'];
    
    // 获取回复信息
    $parentId = isset($_POST['parent_id']) && is_numeric($_POST['parent_id']) ? intval($_POST['parent_id']) : null;
    $replyToUsername = isset($_POST['reply_to_username']) ? trim($_POST['reply_to_username']) : null;

    try {
        // 获取数据库连接
        $pdo = getDbConnection();

        // 验证电影是否存在
        $stmt = $pdo->prepare("SELECT id FROM movies WHERE id = ? AND status = 1");
        $stmt->execute([$movieId]);

        if ($stmt->rowCount() > 0) {
            // 验证评论内容
            if (!empty($username) && !empty($content)) {
                // 插入评论，包含回复信息
                $stmt = $pdo->prepare("INSERT INTO comments (movie_id, username, content, ip_address, parent_id, reply_to_username) VALUES (:movie_id, :username, :content, :ip_address, :parent_id, :reply_to_username)");
                $stmt->execute([
                    ':movie_id' => $movieId,
                    ':username' => $username,
                    ':content' => $content,
                    ':ip_address' => $ipAddress,
                    ':parent_id' => $parentId,
                    ':reply_to_username' => $replyToUsername
                ]);

                // 返回成功信息
                $response['success'] = true;
                $response['message'] = '评论发表成功！';

                // 获取更新后的评论列表
                $comments = $pdo->query("SELECT * FROM comments WHERE movie_id = $movieId AND status = 1 ORDER BY create_time DESC")->fetchAll(PDO::FETCH_ASSOC);
                $response['comments'] = $comments;
                $response['comment_count'] = count($comments);
            } else {
                $response['message'] = '昵称和评论内容不能为空';
            }
        } else {
            $response['message'] = '电影不存在或已下架';
        }
    } catch (PDOException $e) {
        $response['message'] = '数据库错误：' . $e->getMessage();
    }
} else {
    $response['message'] = '请求参数错误';
}

// 输出JSON响应
echo json_encode($response);