<?php
// 引入数据库配置文件
require_once 'config.php';

// 设置返回JSON格式
header('Content-Type: application/json');

// 初始化响应数据
$response = [
    'success' => false,
    'message' => '',
    'comments' => [],
    'comment_count' => 0,
    'has_more' => false
];

// 检查请求参数
if (isset($_GET['movie_id']) && is_numeric($_GET['movie_id'])) {
    $movieId = intval($_GET['movie_id']);
    
    // 获取分页参数，默认第1页，每页10条
    $page = isset($_GET['page']) && is_numeric($_GET['page']) ? intval($_GET['page']) : 1;
    $limit = isset($_GET['limit']) && is_numeric($_GET['limit']) ? intval($_GET['limit']) : 10;
    $offset = ($page - 1) * $limit;
    
    try {
        // 获取数据库连接
        $pdo = getDbConnection();
        
        // 获取评论总数
        $stmt = $pdo->prepare("SELECT COUNT(*) as count FROM comments WHERE movie_id = ? AND status = 1");
        $stmt->execute([$movieId]);
        $countResult = $stmt->fetch(PDO::FETCH_ASSOC);
        $commentCount = $countResult['count'];
        
        // 判断是否还有更多评论
        $hasMore = ($offset + $limit) < $commentCount;
        
        // 获取当前页的评论列表 - 按创建时间倒序排序
        $stmt = $pdo->prepare("SELECT * FROM comments WHERE movie_id = ? AND status = 1 ORDER BY create_time DESC LIMIT ? OFFSET ?");
        $stmt->execute([$movieId, $limit, $offset]);
        
        $comments = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        $response['success'] = true;
        $response['comments'] = $comments;
        $response['comment_count'] = $commentCount;
        $response['has_more'] = $hasMore;
    } catch (PDOException $e) {
        $response['message'] = '数据库错误：' . $e->getMessage();
    }
} else {
    $response['message'] = '请求参数错误';
}

// 输出JSON响应
echo json_encode($response);