<?php
// 引入数据库配置文件
require_once 'config.php';

// 设置响应头为JSON格式
header('Content-Type: application/json');

// 检查参数
if (!isset($_GET['episode_id']) || !is_numeric($_GET['episode_id']) || 
    !isset($_GET['movie_id']) || !is_numeric($_GET['movie_id'])) {
    echo json_encode(['success' => false, 'message' => '参数错误']);
    exit;
}

$episodeId = intval($_GET['episode_id']);
$movieId = intval($_GET['movie_id']);

// 获取数据库连接
$pdo = getDbConnection();

// 查询剧集信息，同时检查相关状态
$stmt = $pdo->prepare("SELECT e.play_url, e.episode_num, e.episode_title, m.title as movie_title 
    FROM episodes e 
    INNER JOIN movies m ON e.movie_id = m.id 
    INNER JOIN video_types vt ON m.type = vt.id 
    INNER JOIN movie_categories mc ON m.category_id = mc.id 
    WHERE e.id = ? AND e.movie_id = ? AND m.status = 1 AND vt.status = 1 AND mc.status = 1");
$stmt->execute([$episodeId, $movieId]);
$episode = $stmt->fetch();

if (!$episode) {
    echo json_encode(['success' => false, 'message' => '剧集不存在或已下架']);
    exit;
}

// 返回成功响应，包含播放URL和剧集信息
echo json_encode([
    'success' => true,
    'play_url' => $episode['play_url'],
    'episode_num' => $episode['episode_num'],
    'episode_title' => $episode['episode_title'],
    'movie_title' => $episode['movie_title']
]);