<?php
// 设置页面标题和活动页面
if (!isset($pageTitle)) {
    $pageTitle = '爱影视';
}
if (!isset($activePage)) {
    $activePage = '';
}
// 可调整的移动端导航断点宽度参数
if (!isset($mobileBreakpoint)) {
    $mobileBreakpoint = 1050; // 默认1050px
}

// 加载数据库配置
require_once 'config.php';

// 获取视频类型列表
$videoTypes = [];
try {
    $db = getDbConnection();
    $stmt = $db->prepare("SELECT id, name, code FROM video_types WHERE status = 1 ORDER BY sort_order ASC");
    $stmt->execute();
    $videoTypes = $stmt->fetchAll();
} catch (PDOException $e) {
    // 数据库查询失败时使用默认类型列表
    $videoTypes = [
        ['id' => 1, 'name' => '电影', 'code' => 'movie'],
        ['id' => 2, 'name' => '剧集', 'code' => 'series'],
        ['id' => 3, 'name' => '动漫', 'code' => 'anime'],
        ['id' => 4, 'name' => '综艺', 'code' => 'variety'],
        ['id' => 5, 'name' => '纪录片', 'code' => 'documentary'],
        ['id' => 6, 'name' => '其他', 'code' => 'other']
    ];
}
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="referrer" content="never">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($pageTitle); ?></title>
    <link rel="shortcut icon" href="favicon.ico" />
    <!-- 引入 Tailwind CSS -->
    <script src="https://registry.npmmirror.com/tailwindcss-cdn/3.4.10/files/tailwindcss.js"></script>
    <!-- 自定义 Tailwind 配置 -->
    <!-- 添加Font Awesome图标库 -->
    <link rel="stylesheet" href="https://registry.npmmirror.com/@fortawesome/fontawesome-free/7.0.1/files/css/all.min.css">
    
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        // 暗色主题颜色配置
                        primary: '#3b82f6',
                        secondary: '#1e293b',
                        dark: '#0f172a',
                        'dark-light': '#1e293b',
                        light: '#f8fafc',
                        muted: '#94a3b8',
                    },
                    fontFamily: {
                        yahei: ['Microsoft YaHei', 'Arial', 'sans-serif'],
                    },
                }
            }
        }
    </script>
    <!-- 自定义工具类 -->
    <style type="text/tailwindcss">
        @layer utilities {
            .content-auto {
                content-visibility: auto;
            }
            .bg-banner {
                background-image: url('../images/banner.jpg');
            }
        }
    </style>
    <link rel="stylesheet" href="css/style.css">
</head>
<body class="font-yahei text-light bg-dark min-h-screen">
    <!-- 导航栏 -->
    <header class="bg-dark-light text-light py-6">
        <div class="container mx-auto px-4 flex flex-col md:flex-row justify-between items-center max-w-7xl">
            <h1 class="text-2xl font-bold mb-4 md:mb-0"><a href="index.php" class="text-primary hover:text-primary transition-colors"><i class="fas fa-play-circle"></i> 爱影视</a></h1>
            
            <!-- 搜索框 -->
            <div class="w-full md:w-80 mb-4 md:mb-0">
                <form action="search.php" method="GET" class="relative group">
                    <input type="text" name="keyword" placeholder="搜索电影、演员、导演..." 
                           class="w-full py-2 px-4 pr-10 bg-dark border border-gray-700 rounded-full focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition-all">
                    <button type="submit" class="absolute right-3 top-1/2 transform -translate-y-1/2 text-muted group-hover:text-primary transition-colors">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                        </svg>
                    </button>
                    <!-- 移除搜索建议下拉框 -->
                </form>
            </div>
            
            <!-- 移动端汉堡菜单按钮 -->
            <button id="mobile-menu-button" class="hidden text-2xl">
                <i class="fas fa-bars"></i>
            </button>
            
            <!-- 桌面端导航 -->
            <nav id="desktop-menu" class="hidden md:flex">
                <ul class="flex space-x-6">
                    <li><a href="index.php" class="px-3 py-2 rounded-md hover:bg-gray-700 transition-colors <?php echo $activePage == 'index' ? 'bg-gray-700' : ''; ?>">首页</a></li>
                    <?php foreach ($videoTypes as $videoType): ?>
                        <li>
                            <a href="category.php?type=<?php echo $videoType['id']; ?>"
                               class="px-3 py-2 rounded-md hover:bg-gray-700 transition-colors
                               <?php echo $activePage == $videoType['code'] ? 'bg-gray-700' : ''; ?>">
                                <?php echo htmlspecialchars($videoType['name']); ?>
                            </a>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </nav>
            </div>
            
            <!-- 移动端导航菜单 (默认隐藏) -->
            <div id="mobile-menu" class="hidden bg-dark-light border-t border-gray-700">
                <div class="container mx-auto px-4 py-4">
                    <ul class="space-y-4">
                        <li><a href="index.php" class="block px-4 py-2 rounded-md hover:bg-gray-700 transition-colors <?php echo $activePage == 'index' ? 'bg-gray-700' : ''; ?>">首页</a></li>
                        <?php foreach ($videoTypes as $videoType): ?>
                            <li>
                                <a href="category.php?type=<?php echo $videoType['id']; ?>
                                   class="block px-4 py-2 rounded-md hover:bg-gray-700 transition-colors
                                   <?php echo $activePage == $videoType['code'] ? 'bg-gray-700' : ''; ?>">
                                    <?php echo htmlspecialchars($videoType['name']); ?>
                                </a>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
    </header>

    <!-- 添加移动端菜单控制脚本 -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // 获取导航元素
            const mobileMenuButton = document.getElementById('mobile-menu-button');
            const mobileMenu = document.getElementById('mobile-menu');
            const desktopMenu = document.getElementById('desktop-menu');
            
            // 设置断点宽度（从PHP传递）
            const mobileBreakpoint = <?php echo $mobileBreakpoint; ?>; // 默认1020px
            
            // 函数：根据窗口宽度切换导航显示
            function toggleNavigationByWidth() {
                if (window.innerWidth < mobileBreakpoint) {
                    // 移动端显示
                    mobileMenuButton.classList.remove('hidden');
                    desktopMenu.classList.add('hidden');
                    // 确保移动端菜单默认为隐藏状态
                    if (!mobileMenu.classList.contains('hidden')) {
                        mobileMenu.classList.add('hidden');
                        // 重置图标为汉堡菜单
                        const icon = mobileMenuButton.querySelector('i');
                        icon.classList.remove('fa-times');
                        icon.classList.add('fa-bars');
                    }
                } else {
                    // 桌面端显示
                    mobileMenuButton.classList.add('hidden');
                    desktopMenu.classList.remove('hidden');
                    mobileMenu.classList.add('hidden'); // 确保移动端菜单隐藏
                }
            }
            
            // 初始加载时检查
            toggleNavigationByWidth();
            
            // 窗口大小变化时检查
            window.addEventListener('resize', toggleNavigationByWidth);
            
            // 点击汉堡菜单按钮切换移动菜单显示/隐藏
            mobileMenuButton.addEventListener('click', function() {
                mobileMenu.classList.toggle('hidden');
                // 切换图标（汉堡菜单/关闭）
                const icon = mobileMenuButton.querySelector('i');
                if (mobileMenu.classList.contains('hidden')) {
                    icon.classList.remove('fa-times');
                    icon.classList.add('fa-bars');
                } else {
                    icon.classList.remove('fa-bars');
                    icon.classList.add('fa-times');
                }
            });
        });
    </script>

    <!-- 主体内容 -->
    <main class="py-0">
        <div class="container mx-auto px-4 max-w-7xl">
