<?php
// 网站安装程序
// 检查是否已经安装
if (file_exists('config.php')) {
    die('<h1>系统已安装</h1><p>如果需要重新安装，请先删除config.php文件。</p>');
}

$step = isset($_GET['step']) ? intval($_GET['step']) : 1;
$errors = [];
$success = '';

// 处理表单提交
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    switch ($step) {
        case 1:
            // 数据库配置
            $db_host = $_POST['db_host'];
            $db_name = $_POST['db_name'];
            $db_user = $_POST['db_user'];
            $db_password = $_POST['db_password'];
            $db_port = $_POST['db_port'];
            $admin_username = $_POST['admin_username'];
            $admin_password = $_POST['admin_password'];
            $admin_password_confirm = $_POST['admin_password_confirm'];

            // 验证表单
            if (empty($db_host) || empty($db_name) || empty($db_user)) {
                $errors[] = '数据库配置信息不完整';
            }
            if (empty($admin_username) || empty($admin_password)) {
                $errors[] = '管理员账号信息不完整';
            }
            if ($admin_password !== $admin_password_confirm) {
                $errors[] = '两次输入的密码不一致';
            }

            if (empty($errors)) {
                // 保存配置到会话，进入下一步
                session_start();
                $_SESSION['db_config'] = [
                    'db_host' => $db_host,
                    'db_name' => $db_name,
                    'db_user' => $db_user,
                    'db_password' => $db_password,
                    'db_port' => $db_port
                ];
                $_SESSION['admin_config'] = [
                    'username' => $admin_username,
                    'password' => $admin_password
                ];
                header('Location: install.php?step=2');
                exit;
            }
            break;
        
        case 2:
            session_start();
            if (!isset($_SESSION['db_config']) || !isset($_SESSION['admin_config'])) {
                header('Location: install.php?step=1');
                exit;
            }
            
            $db_config = $_SESSION['db_config'];
            $admin_config = $_SESSION['admin_config'];
            
            try {
                // 1. 尝试连接数据库
                $dsn = 'mysql:host=' . $db_config['db_host'] . ';port=' . $db_config['db_port'];
                $options = [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                    PDO::ATTR_EMULATE_PREPARES => false
                ];
                $pdo = new PDO($dsn, $db_config['db_user'], $db_config['db_password'], $options);
                
                // 2. 创建数据库（如果不存在）
                $pdo->exec("CREATE DATABASE IF NOT EXISTS `" . $db_config['db_name'] . "` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
                
                // 3. 选择数据库
                $pdo->exec("USE `" . $db_config['db_name'] . "`");
                
                // 检查是否已存在系统表结构
                try {
                    // 查询系统核心表是否存在
                    $stmt = $pdo->query("SHOW TABLES LIKE 'admin_users'");
                    $adminTableExists = $stmt->rowCount() > 0;
                      
                    $stmt = $pdo->query("SHOW TABLES LIKE 'video_types'");
                    $typeTableExists = $stmt->rowCount() > 0;
                      
                    $stmt = $pdo->query("SHOW TABLES LIKE 'movies'");
                    $movieTableExists = $stmt->rowCount() > 0;
                      
                    // 如果任意核心表存在，标记为已有表结构
                    $tablesExist = $adminTableExists || $typeTableExists || $movieTableExists;
                      
                    // 检查是否是确认覆盖的请求
                    $isConfirmOverride = isset($_POST['confirm_override']) && $_POST['confirm_override'] == 1;
                      
                    if ($tablesExist && !$isConfirmOverride) {
                        // 设置会话标记，以便在前端显示确认对话框
                        $_SESSION['tables_exist'] = true;
                        // 跳转到step=2页面，让前端显示确认对话框
                        header('Location: install.php?step=2&confirm=tables_exist');
                        exit;
                    }
                } catch (Exception $e) {
                    // 查询失败时忽略，继续安装流程
                }
                  
                // 4. 创建所有表结构 - 当用户确认覆盖时，先删除已存在的表
                if (isset($_POST['confirm_override']) && $_POST['confirm_override'] == 1) {
                    // 先删除所有可能存在的表
                    $dropTablesSql = "
                    DROP TABLE IF EXISTS `banner`, `comments`, `episodes`, `movies`, `movie_categories`, `video_types`, `admin_users`;
                    ";
                    $pdo->exec($dropTablesSql);
                }
                  
                // 创建所有表结构
                $sql = "
                -- 1. 管理员表
                CREATE TABLE IF NOT EXISTS `admin_users` (
                  `id` int(11) NOT NULL AUTO_INCREMENT,
                  `username` varchar(50) NOT NULL COMMENT '用户名',
                  `password` varchar(255) NOT NULL COMMENT '密码',
                  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态：1启用，0禁用',
                  `last_login_time` datetime DEFAULT NULL COMMENT '最后登录时间',
                  `last_login_ip` varchar(50) DEFAULT NULL COMMENT '最后登录IP',
                  PRIMARY KEY (`id`),
                  UNIQUE KEY `username` (`username`)
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
                
                -- 2. 视频类型表
                CREATE TABLE IF NOT EXISTS `video_types` (
                  `id` int(11) NOT NULL AUTO_INCREMENT,
                  `name` varchar(50) NOT NULL COMMENT '类型名称',
                  `code` varchar(50) NOT NULL COMMENT '类型代码',
                  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态：1启用，0禁用',
                  `sort_order` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
                  PRIMARY KEY (`id`),
                  UNIQUE KEY `code` (`code`)
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
                
                -- 3. 电影分类表
                CREATE TABLE IF NOT EXISTS `movie_categories` (
                  `id` int(11) NOT NULL AUTO_INCREMENT,
                  `name` varchar(50) NOT NULL COMMENT '分类名称',
                  `type` int(11) NOT NULL DEFAULT '1' COMMENT '关联video_types表的id',
                  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态：1启用，0禁用',
                  PRIMARY KEY (`id`),
                  KEY `fk_movie_categories_type` (`type`),
                  CONSTRAINT `fk_movie_categories_type` FOREIGN KEY (`type`) REFERENCES `video_types` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
                
                -- 4. 电影信息表
                CREATE TABLE IF NOT EXISTS `movies` (
                  `id` int(11) NOT NULL AUTO_INCREMENT,
                  `title` varchar(255) NOT NULL COMMENT '电影标题',
                  `subtitle` varchar(255) DEFAULT NULL COMMENT '副标题',
                  `category_id` int(11) NOT NULL COMMENT '分类ID',
                  `type` int(11) NOT NULL DEFAULT '1' COMMENT '关联video_types表的id',
                  `director` varchar(100) DEFAULT NULL COMMENT '导演',
                  `actors` varchar(500) DEFAULT NULL COMMENT '演员',
                  `region` varchar(50) DEFAULT NULL COMMENT '地区',
                  `language` varchar(50) DEFAULT NULL COMMENT '语言',
                  `release_year` year(4) DEFAULT NULL COMMENT '上映年份',
                  `cover_img` varchar(255) DEFAULT NULL COMMENT '封面图片',
                  `description` text COMMENT '剧情简介',
                  `play_url` varchar(255) DEFAULT NULL COMMENT '播放地址(电影)',
                  `total_episodes` int(11) DEFAULT '0' COMMENT '总集数(剧集)',
                  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态：1正常，0下架',
                  `view_count` int(11) NOT NULL DEFAULT '0' COMMENT '观看次数',
                  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
                  PRIMARY KEY (`id`),
                  KEY `category_id` (`category_id`),
                  KEY `fk_movies_type` (`type`),
                  CONSTRAINT `fk_movies_type` FOREIGN KEY (`type`) REFERENCES `video_types` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
                
                -- 5. 剧集分集表
                CREATE TABLE IF NOT EXISTS `episodes` (
                  `id` int(11) NOT NULL AUTO_INCREMENT,
                  `movie_id` int(11) NOT NULL COMMENT '电影ID',
                  `episode_num` int(11) NOT NULL COMMENT '集数',
                  `episode_title` varchar(255) DEFAULT NULL COMMENT '分集标题',
                  `play_url` varchar(255) NOT NULL COMMENT '播放地址',
                  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
                  PRIMARY KEY (`id`),
                  KEY `movie_id` (`movie_id`),
                  CONSTRAINT `fk_episodes_movie` FOREIGN KEY (`movie_id`) REFERENCES `movies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
                
                -- 6. 评论表
                CREATE TABLE IF NOT EXISTS `comments` (
                  `id` int(11) NOT NULL AUTO_INCREMENT,
                  `movie_id` int(11) NOT NULL COMMENT '电影ID',
                  `username` varchar(50) NOT NULL COMMENT '用户名',
                  `content` text NOT NULL COMMENT '评论内容',
                  `ip_address` varchar(50) DEFAULT NULL COMMENT 'IP地址',
                  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态：1显示，0隐藏',
                  `parent_id` int(11) DEFAULT NULL COMMENT '父评论ID（用于回复）',
                  `reply_to_username` varchar(50) DEFAULT NULL COMMENT '被回复的用户名',
                  `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '评论时间',
                  PRIMARY KEY (`id`),
                  KEY `movie_id` (`movie_id`),
                  KEY `parent_id` (`parent_id`),
                  CONSTRAINT `fk_comments_movie` FOREIGN KEY (`movie_id`) REFERENCES `movies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
                  CONSTRAINT `fk_comments_parent` FOREIGN KEY (`parent_id`) REFERENCES `comments` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
                
                -- 7. 轮播图表
                CREATE TABLE IF NOT EXISTS `banner` (
                  `id` int(11) NOT NULL AUTO_INCREMENT,
                  `movie_id` int(11) NOT NULL,
                  `title` varchar(255) NOT NULL,
                  `description` text,
                  `image_url` varchar(255) NOT NULL,
                  `sort_order` int(11) DEFAULT '0',
                  `status` tinyint(1) DEFAULT '1' COMMENT '0: 禁用, 1: 启用',
                  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
                  `update_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                  PRIMARY KEY (`id`),
                  KEY `movie_id` (`movie_id`),
                  CONSTRAINT `fk_banner_movie` FOREIGN KEY (`movie_id`) REFERENCES `movies` (`id`) ON DELETE CASCADE
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
                ";
                
                $pdo->exec($sql);
                
                // 5. 插入初始数据
                // 插入视频类型
                $stmt = $pdo->prepare("INSERT INTO video_types (name, code, status, sort_order) VALUES (?, ?, ?, ?)");
                $stmt->execute(['电影', 'movie', 1, 1]);
                $stmt->execute(['剧集', 'series', 1, 2]);
                $stmt->execute(['动漫', 'anime', 1, 3]);
                $stmt->execute(['综艺', 'variety', 1, 4]);
                $stmt->execute(['其他', 'other', 1, 5]);
                
                // 插入默认分类
                $stmt = $pdo->prepare("INSERT INTO movie_categories (name, type, status) VALUES (?, ?, ?)");
                // 电影分类
                $stmt->execute(['动作片', 1, 1]);
                $stmt->execute(['喜剧片', 1, 1]);
                $stmt->execute(['爱情片', 1, 1]);
                $stmt->execute(['科幻片', 1, 1]);
                $stmt->execute(['恐怖片', 1, 1]);
                $stmt->execute(['剧情片', 1, 1]);
                $stmt->execute(['战争片', 1, 1]);
                $stmt->execute(['记录片', 1, 1]);
                $stmt->execute(['伦理片', 1, 1]);
                $stmt->execute(['动画片', 1, 1]);
                // 剧集分类
                $stmt->execute(['国产剧', 2, 1]);
                $stmt->execute(['香港剧', 2, 1]);
                $stmt->execute(['韩国剧', 2, 1]);
                $stmt->execute(['欧美剧', 2, 1]);
                $stmt->execute(['台湾剧', 2, 1]);
                $stmt->execute(['日本剧', 2, 1]);
                $stmt->execute(['海外剧', 2, 1]);
                $stmt->execute(['泰国剧', 2, 1]);
                $stmt->execute(['短剧', 2, 1]);
                // 动漫分类
                $stmt->execute(['国产动漫', 3, 1]);
                $stmt->execute(['日韩动漫', 3, 1]);
                $stmt->execute(['欧美动漫', 3, 1]);
                $stmt->execute(['港台动漫', 3, 1]);
                $stmt->execute(['海外动漫', 3, 1]);
                // 综艺分类
                $stmt->execute(['大陆综艺', 4, 1]);
                $stmt->execute(['港台综艺', 4, 1]);
                $stmt->execute(['日韩综艺', 4, 1]);
                $stmt->execute(['欧美综艺', 4, 1]);
                // 其他分类
                $stmt->execute(['默认', 5, 1]);
                
                // 插入管理员账号
                $hashed_password = password_hash($admin_config['password'], PASSWORD_DEFAULT);
                $stmt = $pdo->prepare("INSERT INTO admin_users (username, password, status) VALUES (?, ?, ?)");
                $stmt->execute([$admin_config['username'], $hashed_password, 1]);
                
                // 6. 生成配置文件
                $config_content = "<?php
// 数据库配置文件
// 数据库类型
define('DB_TYPE', 'mysql');
// 数据库主机地址
define('DB_HOST', '{$db_config['db_host']}');
// 数据库名称
define('DB_NAME', '{$db_config['db_name']}');
// 数据库用户名
define('DB_USER', '{$db_config['db_user']}');
// 数据库密码
define('DB_PASSWORD', '{$db_config['db_password']}');
// 数据库端口
define('DB_PORT', '{$db_config['db_port']}');
// 数据库连接参数
define('DB_PARAMS', array(
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES => false
));

// 创建数据库连接函数
function getDbConnection() {
    \$dsn = DB_TYPE . ':host=' . DB_HOST . ';dbname=' . DB_NAME . ';port=' . DB_PORT;
    \$options = DB_PARAMS;
    try {
        \$pdo = new PDO(\$dsn, DB_USER, DB_PASSWORD, \$options);
        return \$pdo;
    } catch (PDOException \$e) {
        die('数据库连接失败: ' . \$e->getMessage());
    }
}
?>
";
                
                if (file_put_contents('config.php', $config_content) === false) {
                    throw new Exception('无法创建配置文件，请确保目录有写权限');
                }
                
                // 7. 安装完成，清除会话
                session_destroy();
                $step = 3;
                
            } catch (Exception $e) {
                $errors[] = '安装过程中出错: ' . $e->getMessage();
            }
            break;
    }
}
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>爱影视 - 安装向导</title>
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
            background-color: #f5f5f5;
            margin: 0;
            padding: 0;
            color: #333;
        }
        .container {
            max-width: 800px;
            margin: 50px auto;
            background-color: white;
            border-radius: 8px;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.1);
            overflow: hidden;
        }
        .header {
            background-color: #1e88e5;
            color: white;
            padding: 20px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 28px;
        }
        .content {
            padding: 30px;
        }
        .step-indicator {
            display: flex;
            margin-bottom: 30px;
        }
        .step-item {
            flex: 1;
            text-align: center;
            position: relative;
            padding-bottom: 20px;
        }
        .step-item:not(:last-child):after {
            content: '';
            position: absolute;
            top: 15px;
            right: 0;
            width: 100%;
            height: 2px;
            background-color: #e0e0e0;
            z-index: 1;
        }
        .step-number {
            display: inline-block;
            width: 30px;
            height: 30px;
            line-height: 30px;
            border-radius: 50%;
            background-color: #e0e0e0;
            color: #666;
            font-weight: bold;
            position: relative;
            z-index: 2;
        }
        .step-item.active .step-number {
            background-color: #1e88e5;
            color: white;
        }
        .step-item.completed .step-number {
            background-color: #4caf50;
            color: white;
        }
        .step-item.completed:not(:last-child):after {
            background-color: #4caf50;
        }
        .step-label {
            display: block;
            margin-top: 8px;
            font-size: 14px;
            color: #666;
        }
        .form-group {
            margin-bottom: 20px;
        }
        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 500;
            color: #555;
        }
        .form-group input {
            width: 100%;
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 16px;
            box-sizing: border-box;
        }
        .form-group input:focus {
            outline: none;
            border-color: #1e88e5;
            box-shadow: 0 0 0 2px rgba(30, 136, 229, 0.2);
        }
        .btn {
            display: inline-block;
            padding: 12px 24px;
            background-color: #1e88e5;
            color: white;
            border: none;
            border-radius: 4px;
            font-size: 16px;
            cursor: pointer;
            text-decoration: none;
            transition: background-color 0.3s;
        }
        .btn:hover {
            background-color: #1565c0;
        }
        .errors {
            background-color: #ffebee;
            color: #c62828;
            padding: 15px;
            border-radius: 4px;
            margin-bottom: 20px;
        }
        .errors ul {
            margin: 0;
            padding-left: 20px;
        }
        .success {
            background-color: #e8f5e9;
            color: #2e7d32;
            padding: 15px;
            border-radius: 4px;
            margin-bottom: 20px;
        }
        .info-box {
            background-color: #e3f2fd;
            border-left: 4px solid #1e88e5;
            padding: 15px;
            margin-bottom: 20px;
        }
        .info-box p {
            margin: 0;
        }
        .install-complete {
            text-align: center;
            padding: 40px 0;
        }
        .install-complete h2 {
            color: #4caf50;
            margin-bottom: 20px;
        }
        .install-complete p {
            font-size: 16px;
            color: #666;
            margin-bottom: 30px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>爱影视 - 安装向导</h1>
        </div>
        <div class="content">
            <!-- 步骤指示器 -->
            <div class="step-indicator">
                <div class="step-item<?php if ($step >= 1) echo ' active'; if ($step > 1) echo ' completed'; ?>">
                    <span class="step-number">1</span>
                    <span class="step-label">配置信息</span>
                </div>
                <div class="step-item<?php if ($step >= 2) echo ' active'; if ($step > 2) echo ' completed'; ?>">
                    <span class="step-number">2</span>
                    <span class="step-label">安装过程</span>
                </div>
                <div class="step-item<?php if ($step >= 3) echo ' active'; ?>">
                    <span class="step-number">3</span>
                    <span class="step-label">完成安装</span>
                </div>
            </div>

            <!-- 显示错误信息 -->
            <?php if (!empty($errors)): ?>
                <div class="errors">
                    <ul>
                        <?php foreach ($errors as $error): ?>
                            <li><?php echo $error; ?></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            <?php endif; ?>

            <!-- 显示成功信息 -->
            <?php if (!empty($success)): ?>
                <div class="success">
                    <?php echo $success; ?>
                </div>
            <?php endif; ?>

            <!-- 步骤内容 -->
            <?php if ($step == 1): ?>
                <h2>数据库配置</h2>
                <div class="info-box">
                    <p>请填写您的数据库连接信息和管理员账号信息，完成后点击"开始安装"按钮。</p>
                </div>
                <form method="post" action="install.php?step=1">
                    <div class="form-group">
                        <label for="db_host">数据库主机地址</label>
                        <input type="text" id="db_host" name="db_host" value="localhost" required>
                    </div>
                    <div class="form-group">
                        <label for="db_port">数据库端口</label>
                        <input type="text" id="db_port" name="db_port" value="3306" required>
                    </div>
                    <div class="form-group">
                        <label for="db_name">数据库名称</label>
                        <input type="text" id="db_name" name="db_name" required>
                    </div>
                    <div class="form-group">
                        <label for="db_user">数据库用户名</label>
                        <input type="text" id="db_user" name="db_user" required>
                    </div>
                    <div class="form-group">
                        <label for="db_password">数据库密码</label>
                        <input type="password" id="db_password" name="db_password">
                    </div>
                    <h3 style="margin-top: 30px;">管理员账号设置</h3>
                    <div class="form-group">
                        <label for="admin_username">管理员用户名</label>
                        <input type="text" id="admin_username" name="admin_username" required>
                    </div>
                    <div class="form-group">
                        <label for="admin_password">管理员密码</label>
                        <input type="password" id="admin_password" name="admin_password" required>
                    </div>
                    <div class="form-group">
                        <label for="admin_password_confirm">确认密码</label>
                        <input type="password" id="admin_password_confirm" name="admin_password_confirm" required>
                    </div>
                    <div style="margin-top: 30px;">
                        <button type="submit" class="btn">开始安装</button>
                    </div>
                </form>
            <?php elseif ($step == 2): ?>
                <h2>正在安装...</h2>
                <div class="info-box">
                    <p>系统正在创建数据库表结构和初始数据，请稍候...</p>
                </div>
                <form method="post" action="install.php?step=2" id="install-form">
                    <input type="hidden" name="install" value="1">
                    <input type="hidden" name="confirm_override" value="1">
                </form>
                <script>
                    document.addEventListener('DOMContentLoaded', function() {
                        // 检查URL参数，判断是否需要显示确认对话框
                        const urlParams = new URLSearchParams(window.location.search);
                          
                        if (urlParams.get('confirm') === 'tables_exist') {
                            // 显示确认对话框
                            if (confirm('检测到数据库中已存在表结构。\n继续安装将会直接覆盖所有已存在的表结构和数据，是否确定要继续？')) {
                                // 用户确认继续，提交表单
                                document.getElementById('install-form').submit();
                            } else {
                                // 用户取消，返回配置页面
                                window.location.href = 'install.php?step=1';
                            }
                        } else {
                            // 没有需要确认的情况，自动提交表单
                            document.getElementById('install-form').submit();
                        }
                    });
                </script>
            <?php elseif ($step == 3): ?>
                <div class="install-complete">
                    <h2>🎉 安装完成！</h2>
                    <p>爱影视网站已经成功安装完成。</p>
                    <p>以下是您需要了解的信息：</p>
                    <ul style="text-align: left; max-width: 500px; margin: 20px auto;">
                        <li>后台管理地址：<strong>/backend</strong></li>
                        <li>请使用您设置的管理员账号登录后台</li>
                        <li>建议删除install.php文件以提高安全性</li>
                    </ul>
                    <div style="margin-top: 30px;">
                        <a href="/" class="btn">访问前台</a>
                        <a href="/backend" class="btn" style="margin-left: 10px;">进入后台</a>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>