<?php
// 引入数据库配置文件
require_once 'config.php';

// 检查是否提供了电影ID
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die('参数错误');
}

$movieId = intval($_GET['id']);

// 在获取电影信息后添加查询总集数的代码
// 获取数据库连接
$pdo = getDbConnection();

// 获取电影信息
$movie = $pdo->query("SELECT * FROM movies WHERE id = $movieId AND status = 1")->fetch();

if (!$movie) {
    die('电影不存在或已下架');
}

$total_episodes_result = $pdo->query("SELECT COUNT(*) FROM episodes WHERE movie_id = $movieId")->fetchColumn();
$total_episodes = $total_episodes_result ? $total_episodes_result : 0;

// 更新观看次数
$pdo->exec("UPDATE movies SET view_count = view_count + 1 WHERE id = $movieId");

// 获取分类名称
$category = $pdo->query("SELECT name FROM movie_categories WHERE id = {$movie['category_id']}")->fetch();
$categoryName = $category ? $category['name'] : '';

// 获取剧集分集
$episodes = [];
// 移除类型限制，所有类型视频都可以获取分集
$episodes = $pdo->query("SELECT * FROM episodes WHERE movie_id = $movieId ORDER BY episode_num")->fetchAll();

// 获取当前播放的集数
$currentEpisodeId = isset($_GET['episode_id']) ? intval($_GET['episode_id']) : 0;
$currentPlayUrl = $movie['play_url'];
$currentEpisodeInfo = '';

// 如果指定了集数，获取该集的播放地址
if ($currentEpisodeId > 0) {
    $currentEpisode = $pdo->query("SELECT play_url, episode_num, episode_title FROM episodes WHERE id = $currentEpisodeId AND movie_id = $movieId")->fetch();
    if ($currentEpisode) {
        $currentPlayUrl = $currentEpisode['play_url'];
        // 设置当前集数信息
        if (!empty($currentEpisode['episode_title'])) {
            $currentEpisodeInfo = ' - ' . $currentEpisode['episode_title'];
        } else {
            $currentEpisodeInfo = ' - 第' . $currentEpisode['episode_num'] . '集';
        }
    }
} elseif (!empty($episodes)) {
    // 默认播放第一集
    $currentPlayUrl = $episodes[0]['play_url'];
    $currentEpisodeId = $episodes[0]['id'];
    // 设置当前集数信息
    if (!empty($episodes[0]['episode_title'])) {
        $currentEpisodeInfo = ' - ' . $episodes[0]['episode_title'];
    } else {
        $currentEpisodeInfo = ' - 第' . $episodes[0]['episode_num'] . '集';
    }
}

// 设置页面标题和活动页面
$pageTitle = $movie['title'] . $currentEpisodeInfo . ' - 爱影视';
$activePage = '';
switch($movie['type']) {
    case 1:
        $activePage = 'movies';
        break;
    case 2:
        $activePage = 'tvshows';
        break;
    case 3:
        $activePage = 'anime';
        break;
    case 4:
        $activePage = 'variety';
        break;
    case 5:
        $activePage = 'documentary';
        break;
    case 6:
        $activePage = 'other';
        break;
    default:
        $activePage = '';
}

// 获取评论总数（仅用于初始显示）
$commentCount = $pdo->query("SELECT COUNT(*) FROM comments WHERE movie_id = $movieId AND status = 1")->fetchColumn();

// 引入共用的头部
require_once 'includes/header.php';
?>

<!-- 添加HLS.js库 -->
<script src="https://registry.npmmirror.com/hls.js/1.6.12/files/dist/hls.min.js"></script>

<div class="container mx-auto px-4 py-8 max-w-7xl">
    <!-- 视频播放区域 - 直接使用video标签，移除video-section容器 -->
    <video controls class="w-full aspect-video bg-black rounded-lg mb-8">
        <source src="<?php echo $currentPlayUrl; ?>" type="video/mp4">
        您的浏览器不支持HTML5视频播放。请更新浏览器或使用其他浏览器观看。
    </video>

    <!-- 分集列表 - 修改条件判断，只有当剧集数量>=2时才显示 -->
    <?php if (!empty($episodes) && count($episodes) >= 2): ?>
        <section class="episodes-list mb-8">
            <div class="flex items-center justify-between mb-3">
                <h4 class="text-lg font-bold">选集</h4>
                <label id="autoPlayNextToggle" class="relative inline-flex items-center cursor-pointer">
                    <input type="checkbox" id="toggleSwitch" class="sr-only peer" checked>
                    <div class="w-14 h-7 bg-gray-300 peer-checked:bg-blue-500 rounded-full transition-all duration-300 ease-in-out"></div>
                    <div class="absolute left-1 top-1 bg-white w-5 h-5 rounded-full transition-all duration-300 ease-in-out transform peer-checked:translate-x-7 shadow-sm"></div>
                    <span class="ml-2">自动下一集</span>
                </label>
            </div>
            <div class="episodes-grid flex flex-wrap gap-2">
                <?php foreach ($episodes as $episode): ?>
                    <button class="episode-item px-3 py-2 bg-secondary rounded-md cursor-pointer text-gray-400 transition-all hover:bg-primary hover:text-white <?php echo $episode['id'] == $currentEpisodeId ? 'bg-primary text-white' : ''; ?>" 
                            data-episode-id="<?php echo $episode['id']; ?>" 
                            data-movie-id="<?php echo $movieId; ?>">
                        <?php if (!empty($episode['episode_title'])): ?>
                            <?php echo htmlspecialchars($episode['episode_title']); ?>
                        <?php else: ?>
                            第<?php echo $episode['episode_num']; ?>集
                        <?php endif; ?>
                    </button>
                <?php endforeach; ?>
            </div>
        </section>
    <?php endif; ?>

    <!-- 电影信息 -->
    <div class="movie-info bg-dark-light p-6 rounded-lg mb-8">
        <div class="flex flex-col md:flex-row gap-6">
            <!-- 电影海报 -->
            <div class="movie-poster w-full md:w-48 shrink-0">
                <img src="<?php echo $movie['cover_img'] ?: 'images/default_cover.jpg'; ?>" alt="<?php echo $movie['title']; ?>" class="w-full h-auto rounded-md">
            </div>
            
            <!-- 电影详细信息 -->
            <div class="movie-details">
                <h2 class="text-2xl font-bold mb-3 text-light"><?php echo $movie['title']; ?></h2>
                <?php if (!empty($movie['subtitle'])): ?>
                <p class="text-lg text-primary/80 mb-3"><?php echo $movie['subtitle']; ?></p>
                <?php endif; ?>
                <div class="movie-meta mb-4">
                    <p class="mb-1 text-sm text-muted">导演：<?php echo $movie['director']; ?></p>
                    <p class="mb-1 text-sm text-muted">主演：<?php echo $movie['actors']; ?></p>
                    <p class="mb-1 text-sm text-muted">地区：<?php echo $movie['region']; ?></p>
                    <p class="mb-1 text-sm text-muted">语言：<?php echo $movie['language']; ?></p>
                    <p class="mb-1 text-sm text-muted">上映年份：<?php echo $movie['release_year']; ?></p>
                    <?php if (!empty($movie['total_episodes'])): ?>
                    <p class="mb-1 text-sm text-muted">总集数：<?php echo $movie['total_episodes']; ?></p>
                    <?php endif; ?>
                    <p class="text-sm text-muted">观看次数：<?php echo $movie['view_count']; ?></p>
                </div>
            </div>
        </div>
    </div>

    <!-- 剧情简介 -->
    <section class="description bg-dark-light p-6 rounded-lg mb-8">
        <h3 class="text-xl font-bold mb-4">剧情简介</h3>
        <p id="description-content" class="line-clamp-3 mb-4 text-light"><?php echo $movie['description']; ?></p>
        <div class="text-right">
            <button id="toggle-description" class="text-primary hover:text-primary/80 transition-colors">
                查看更多
            </button>
        </div>
    </section>
    
    <script>
        // 剧情简介展开/收起功能
        document.addEventListener('DOMContentLoaded', function() {
            const descriptionContent = document.getElementById('description-content');
            const toggleButton = document.getElementById('toggle-description');
            let isExpanded = false;
            
            toggleButton.addEventListener('click', function() {
                if (isExpanded) {
                    // 收起
                    descriptionContent.classList.add('line-clamp-3');
                    toggleButton.textContent = '查看更多';
                } else {
                    // 展开
                    descriptionContent.classList.remove('line-clamp-3');
                    toggleButton.textContent = '收起';
                }
                isExpanded = !isExpanded;
            });
        });
    </script>

    <!-- 在视频播放区域下方添加快捷键帮助按钮 -->
    <div class="flex justify-center mb-8">
        <button id="downloadVideoBtn" class="mr-4 px-4 py-2 bg-secondary text-gray-400 hover:bg-primary hover:text-white transition-colors rounded-md">
            <i class="fas fa-download mr-1"></i> 下载视频
        </button>
        <button id="toggleShortcutHelp" class="px-4 py-2 bg-secondary text-gray-400 hover:text-white transition-colors rounded-md">
            <i class="fas fa-keyboard mr-1"></i> 按<span> H </span>查看快捷键
        </button>
    </div>
    <!-- 键盘快捷键帮助面板 -->
    <div id="shortcutHelp" class="hidden">
        <h3><i class="fas fa-keyboard"></i> 键盘快捷键</h3>
        <div class="shortcuts-grid">
            <div class="shortcut-item"><div class="key">S</div><div class="action">复制分享链接</div></div>
            <div class="shortcut-item"><div class="key">D</div><div class="action">下载视频</div></div>
            <div class="shortcut-item"><div class="key">空格</div><div class="action">播放/暂停</div></div>
            <div class="shortcut-item"><div class="key">M</div><div class="action">静音切换</div></div>
            <div class="shortcut-item"><div class="key">→</div><div class="action">快进</div></div>
            <div class="shortcut-item"><div class="key">←</div><div class="action">快退</div></div>
            <div class="shortcut-item"><div class="key">↑</div><div class="action">增加音量</div></div>
            <div class="shortcut-item"><div class="key">↓</div><div class="action">降低音量</div></div>
            <div class="shortcut-item"><div class="key">[</div><div class="action">减速播放</div></div>
            <div class="shortcut-item"><div class="key">]</div><div class="action">加速播放</div></div>
            <div class="shortcut-item"><div class="key">Page Up</div><div class="action">上一集</div></div>
            <div class="shortcut-item"><div class="key">Page Down</div><div class="action">下一集</div></div>
            <div class="shortcut-item"><div class="key">Enter</div><div class="action">全屏切换</div></div>
            <div class="shortcut-item"><div class="key">F</div><div class="action">窗口全屏切换</div></div>
            <div class="shortcut-item"><div class="key">P</div><div class="action">画中画模式</div></div>
            <div class="shortcut-item"><div class="key">N</div><div class="action">自动下一集切换</div></div>
            <div class="shortcut-item"><div class="key">ESC</div><div class="action">功能关闭</div></div>
            <div class="shortcut-item"><div class="key">H</div><div class="action">显示帮助</div></div>
        </div>
    </div>

    <!-- 下载弹窗（Modal） -->
    <div id="downloadModal" class="download-modal">
        <div class="download-modal-content">
            <div class="download-modal-header">
                <h3>视频下载</h3>
                <button id="closeDownloadModal" class="close-btn"><i class="fas fa-times"></i></button>
            </div>
            <div class="download-modal-body">
                <div id="downloadFrameContainer" class="download-frame-container">
                    <!-- 将在这里动态注入 iframe -->
                </div>
            </div>
        </div>
    </div>

    <!-- 评论区 -->
    <section class="comments-section">
        <h3 class="text-xl font-bold mb-4">评论 (<?php echo $commentCount; ?>)</h3>
        
        <!-- 评论表单 -->
        <div class="comment-form mb-6 p-4 bg-dark-light rounded-lg">
            <h4 class="text-lg font-medium mb-3">发表评论</h4>
            <form>
                <input type="text" name="username" placeholder="请输入您的昵称" required class="w-full p-2 mb-3 bg-secondary border border-gray-700 rounded-md text-light placeholder:text-muted">
                <textarea name="content" placeholder="请输入评论内容" required class="w-full p-2 mb-3 bg-secondary border border-gray-700 rounded-md h-24 resize-vertical text-light placeholder:text-muted"></textarea>
                <button type="submit" class="px-4 py-2 bg-primary text-white rounded-md hover:bg-primary/90 transition-colors">提交评论</button>
            </form>
        </div>

        <!-- 评论列表 -->
        <div class="comments-list">
            <!-- 评论将通过AJAX动态加载 -->
            <div class="loading-comments flex items-center justify-center p-8 text-muted">
                <div class="w-6 h-6 border-2 border-primary border-t-transparent rounded-full animate-spin mr-3"></div>
                加载评论中...
            </div>
        </div>
    </section>
</div>

<!-- 添加视频播放器脚本 -->
<script src="js/video-player.js"></script>
<!-- 引入评论相关的JavaScript -->
<script src="js/ajax-comment.js"></script>

<?php
// 引入共用的页脚
require_once 'includes/footer.php';
?>
